/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepHistory;
import filenet.vw.api.VWWorkflowHistory;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkLaunchStep;
import filenet.vw.toolkit.runtime.VWTrkRoute;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class VWTrkMap
implements ItemListener {
    private VWTrkDataModel m_dataModel = null;
    private VWMapDefinition m_mapDefinition = null;
    private VWWorkflowHistory m_workflowHistory = null;
    private boolean m_bMainMap = false;
    private int m_mapId = -1;
    private Vector m_parentMaps = null;
    private Vector m_steps = null;
    private Vector m_selectedSteps = new Vector();
    private Vector m_selectedRoutes = new Vector();
    private VWTrkLaunchStep m_launchStep = null;
    private VWTrkStep m_startStep = null;
    private Vector m_routes = null;
    private Vector m_callingSteps = null;
    private Vector m_stepsChanged = null;
    private int m_propertyChangeType;

    public VWTrkMap(VWTrkDataModel dataModel, VWMapDefinition mapDefinition, boolean bMainMap) throws Exception {
        this.m_dataModel = dataModel;
        this.m_bMainMap = bMainMap;
        if (mapDefinition != null) {
            this.m_mapDefinition = mapDefinition;
            this.m_mapId = this.m_mapDefinition.getMapId();
        }
    }

    void initStepHistory() throws Exception {
        if (this.m_steps == null || this.m_steps.size() == 0) {
            return;
        }
        try {
            VWProcess process = this.m_dataModel.getProcess();
            if (process == null) {
                return;
            }
            this.m_workflowHistory = process.fetchWorkflowHistory(this.m_mapId);
            if (this.m_launchStep != null) {
                this.m_launchStep.initLaunchHistory(this.m_workflowHistory);
            }
            while (this.m_workflowHistory.hasNext()) {
                VWStepHistory stepHistory = this.m_workflowHistory.next();
                if (stepHistory == null) continue;
                int stepId = stepHistory.getStepId();
                for (int i = 0; i < this.m_steps.size(); ++i) {
                    VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
                    if (step == null) continue;
                    if (step.isLaunchStep() && stepId == 0) {
                        step.addStepHistory(stepHistory);
                        continue;
                    }
                    if (stepId != step.getMapNode().getStepId()) continue;
                    step.addStepHistory(stepHistory);
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            throw new Exception(VWResource.s_failedToInitializeStepHistory);
        }
    }

    protected void initStepDefinition() throws Exception {
        if (this.m_mapDefinition == null) {
            return;
        }
        this.m_steps = new Vector();
        this.m_routes = new Vector();
        try {
            boolean dataIndex = false;
            VWMapNode[] vwMapNodes = this.m_mapDefinition.getSteps();
            if (vwMapNodes != null) {
                for (int index = 0; index < vwMapNodes.length; ++index) {
                    VWTrkRoute route;
                    int rIndex;
                    VWTrkStep step;
                    if (this.isLaunchStep(vwMapNodes[index])) {
                        this.m_launchStep = new VWTrkLaunchStep(this, (VWStepDefinition)vwMapNodes[index]);
                        this.m_startStep = this.m_launchStep;
                        step = this.m_launchStep;
                    } else {
                        step = new VWTrkStep(this, vwMapNodes[index]);
                        if (this.isStartStep(vwMapNodes[index])) {
                            this.m_startStep = step;
                        }
                    }
                    this.m_steps.addElement(step);
                    VWRouteDefinition[] vwRoutes = vwMapNodes[index].getNextRoutes();
                    if (vwRoutes != null) {
                        for (rIndex = 0; rIndex < vwRoutes.length; ++rIndex) {
                            route = this.findRoute(vwRoutes[rIndex].getRouteId());
                            if (route == null) {
                                route = new VWTrkRoute(vwRoutes[rIndex]);
                                this.m_routes.addElement(route);
                            }
                            route.setPreviousStep(step);
                            step.addNextRoute(route);
                        }
                    }
                    if ((vwRoutes = vwMapNodes[index].getPreviousRoutes()) == null) continue;
                    for (rIndex = 0; rIndex < vwRoutes.length; ++rIndex) {
                        route = this.findRoute(vwRoutes[rIndex].getRouteId());
                        if (route == null) {
                            route = new VWTrkRoute(vwRoutes[rIndex]);
                            this.m_routes.addElement(route);
                        }
                        route.setNextStep(step);
                        step.addPreviousRoute(route);
                    }
                }
            }
        }
        catch (VWException e) {
            VWDebug.logException(e);
            throw new Exception(VWResource.s_failedToInitializeStepDefinition);
        }
        this.m_steps = VWTrkDataModel.sortSteps(this.m_steps);
        this.m_routes = VWTrkDataModel.sortRoutes(this.m_routes);
    }

    public boolean isMainmap() {
        return this.m_bMainMap;
    }

    public boolean isLaunchStep(VWMapNode node) {
        if (node == null) {
            return false;
        }
        if (this.m_mapId != -2) {
            return false;
        }
        VWMapNode launchStepNode = null;
        if (this.m_launchStep == null) {
            try {
                launchStepNode = this.m_mapDefinition.getStartStep();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                return false;
            }
        } else {
            launchStepNode = this.m_launchStep.getStepDefinition();
        }
        return launchStepNode == node;
    }

    public boolean isStartStep(VWMapNode node) {
        if (this.m_mapDefinition == null) {
            return false;
        }
        VWMapNode startStepNode = null;
        if (this.m_startStep == null) {
            try {
                startStepNode = this.m_mapDefinition.getStartStep();
            }
            catch (VWException ex) {
                return false;
            }
        } else {
            startStepNode = this.m_startStep.getMapNode();
        }
        return startStepNode == node;
    }

    public VWMapDefinition getMapDefinition() {
        return this.m_mapDefinition;
    }

    public VWTrkStep findStep(int stepId) {
        if (this.m_steps == null) {
            return null;
        }
        int count = this.m_steps.size();
        if (count == 0) {
            return null;
        }
        VWTrkStep step = null;
        for (int i = 0; i < count; ++i) {
            step = (VWTrkStep)this.m_steps.elementAt(i);
            if (step.getStepId() != stepId) continue;
            return step;
        }
        return null;
    }

    public VWTrkRoute findRoute(int routeId) {
        if (this.m_routes == null) {
            return null;
        }
        int count = this.m_routes.size();
        if (count == 0) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            VWTrkRoute route = (VWTrkRoute)this.m_routes.elementAt(i);
            if (route.getRouteId() != routeId) continue;
            return route;
        }
        return null;
    }

    public Vector getStepCollection() {
        return this.m_steps;
    }

    public Vector getRouteCollection() {
        return this.m_routes;
    }

    public Vector getActiveSteps() {
        if (this.m_steps == null) {
            return null;
        }
        Vector<VWTrkStep> collection = new Vector<VWTrkStep>();
        for (int i = 0; i < this.m_steps.size(); ++i) {
            VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
            if (!step.isActive()) continue;
            collection.addElement(step);
        }
        if (collection.size() > 0) {
            return collection;
        }
        return null;
    }

    public boolean isAltered() {
        if (this.m_steps == null || this.m_steps.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_steps.size(); ++i) {
            VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
            if (!step.isAltered()) continue;
            return true;
        }
        return false;
    }

    public boolean isLockedByCurrentUser() {
        if (this.m_steps == null || this.m_steps.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_steps.size(); ++i) {
            VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
            if (!step.isActive()) continue;
            Vector occurrences = step.getActiveOccurrences();
            for (int j = 0; j < occurrences.size(); ++j) {
                Object obj = occurrences.elementAt(j);
                if (obj == null || !(obj instanceof VWTrkStepOccurrence) || !((VWTrkStepOccurrence)obj).isSomeLockedByCurrentUser()) continue;
                return true;
            }
        }
        return false;
    }

    void updateStepHistory(VWTrkStep step) {
        try {
            this.m_workflowHistory.resetFetch();
            VWStepHistory stepHistory = this.m_workflowHistory.fetchStepHistory(step.getStepId());
            if (stepHistory != null) {
                step.addStepHistory(stepHistory);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public void saveAllChanges() throws VWException {
        if (this.m_steps != null && this.m_steps.size() == 0) {
            return;
        }
        VWException exception = null;
        for (int i = 0; i < this.m_steps.size(); ++i) {
            VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
            if (step == null) continue;
            try {
                step.save();
                continue;
            }
            catch (VWException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public Vector getAlteredSteps() {
        if (this.m_steps != null && this.m_steps.size() == 0) {
            return null;
        }
        Vector<VWTrkStep> steps = new Vector<VWTrkStep>();
        for (int i = 0; i < this.m_steps.size(); ++i) {
            VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
            if (step == null || !step.isAltered()) continue;
            steps.addElement(step);
        }
        return steps;
    }

    void removeAllWorkObjects(boolean bSave) {
        if (this.m_steps == null) {
            return;
        }
        for (int i = 0; i < this.m_steps.size(); ++i) {
            VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
            if (step == null) continue;
            step.removeAllWorkObjects(bSave);
        }
    }

    void removeHistory() {
        if (this.m_steps == null) {
            return;
        }
        for (int i = 0; i < this.m_steps.size(); ++i) {
            VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
            if (step == null) continue;
            step.removeHistory();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.m_selectedSteps.removeAllElements();
        this.m_selectedRoutes.removeAllElements();
        ItemSelectable itemSelectable = e.getItemSelectable();
        Object[] objects = itemSelectable.getSelectedObjects();
        if (objects != null) {
            Object obj = null;
            boolean id = false;
            VWTrkStep step = null;
            VWTrkRoute route = null;
            for (int i = 0; i < objects.length; ++i) {
                obj = objects[i];
                if (obj == null) continue;
                if (obj instanceof VWMapNode) {
                    step = this.findStep(((VWMapNode)obj).getStepId());
                    if (step != null) {
                        this.m_selectedSteps.addElement(step);
                    }
                } else if (obj instanceof VWRouteDefinition) {
                    route = this.findRoute(((VWRouteDefinition)obj).getRouteId());
                }
                if (route == null) continue;
                this.m_selectedRoutes.addElement(route);
            }
        }
    }

    public Vector getSteps() {
        return this.m_steps;
    }

    public Vector getSelectedSteps() {
        return this.m_selectedSteps;
    }

    public int getMapId() {
        return this.m_mapId;
    }

    public String getMapName() {
        if (this.m_mapDefinition != null) {
            return this.m_mapDefinition.getName();
        }
        return null;
    }

    public VWTrkDataModel getDataModel() {
        return this.m_dataModel;
    }

    protected void addCallingStep(VWTrkStep step) {
        if (this.m_callingSteps == null) {
            this.m_callingSteps = new Vector();
        }
        this.m_callingSteps.add(step);
        this.addParentMap(step.getMap());
    }

    public Vector getCallingSteps() {
        if (this.m_callingSteps == null) {
            this.m_callingSteps = new Vector();
        }
        return this.m_callingSteps;
    }

    private void addParentMap(VWTrkMap map) {
        VWTrkMap firstMap;
        if (map == null) {
            return;
        }
        String mapName = map.getMapName();
        if (mapName == null) {
            return;
        }
        boolean bMainMap = false;
        if (this.m_parentMaps == null) {
            this.m_parentMaps = new Vector();
        } else if (this.m_parentMaps.size() > 0 && (firstMap = (VWTrkMap)this.m_parentMaps.elementAt(0)).isMainmap()) {
            bMainMap = true;
        }
        if (map.isMainmap()) {
            if (!bMainMap) {
                this.m_parentMaps.insertElementAt(map, 0);
            }
            return;
        }
        int i = 0;
        if (bMainMap) {
            i = 1;
        }
        while (i < this.m_parentMaps.size()) {
            String name;
            Object obj = this.m_parentMaps.elementAt(i);
            if (obj != null && obj instanceof VWTrkMap && (name = ((VWTrkMap)obj).getMapName()) != null) {
                int result = VWStringUtils.compare(name, mapName);
                if (result == 0) {
                    return;
                }
                if (result > 0) break;
            }
            ++i;
        }
        this.m_parentMaps.insertElementAt(map, i);
    }

    public Vector getParentMaps() {
        return this.m_parentMaps;
    }

    public VWTrkLaunchStep getLaunchStep() {
        return this.m_launchStep;
    }

    public void removeReferences() {
        Object obj;
        int i;
        this.m_dataModel = null;
        this.m_mapDefinition = null;
        this.m_workflowHistory = null;
        if (this.m_parentMaps != null) {
            for (i = 0; i < this.m_parentMaps.size(); ++i) {
                obj = this.m_parentMaps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMap) || ((VWTrkMap)obj).getMapId() == this.getMapId()) continue;
                ((VWTrkMap)obj).removeReferences();
            }
            this.m_parentMaps.removeAllElements();
            this.m_parentMaps = null;
        }
        if (this.m_steps != null) {
            for (i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStep)) continue;
                ((VWTrkStep)obj).removeReferences();
            }
            this.m_steps.removeAllElements();
            this.m_steps = null;
        }
        if (this.m_selectedSteps != null) {
            for (i = 0; i < this.m_selectedSteps.size(); ++i) {
                obj = this.m_selectedSteps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStep)) continue;
                ((VWTrkStep)obj).removeReferences();
            }
            this.m_selectedSteps.removeAllElements();
            this.m_selectedSteps = null;
        }
        this.m_launchStep = null;
        this.m_startStep = null;
        if (this.m_selectedRoutes != null) {
            for (i = 0; i < this.m_selectedRoutes.size(); ++i) {
                obj = this.m_selectedRoutes.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkRoute)) continue;
                ((VWTrkRoute)obj).removeReferences();
            }
            this.m_selectedRoutes.removeAllElements();
            this.m_selectedRoutes = null;
        }
        if (this.m_routes != null) {
            for (i = 0; i < this.m_routes.size(); ++i) {
                obj = this.m_routes.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkRoute)) continue;
                ((VWTrkRoute)obj).removeReferences();
            }
            this.m_routes.removeAllElements();
            this.m_routes = null;
        }
        if (this.m_callingSteps != null) {
            this.m_callingSteps.removeAllElements();
            this.m_callingSteps = null;
        }
        if (this.m_stepsChanged != null) {
            this.m_stepsChanged.removeAllElements();
            this.m_stepsChanged = null;
        }
    }
}

